#include <stdio.h>
#include <hidapi/hidapi.h>
#include <stdint.h>
#include <string.h>

// Build:
// gcc rifts-init.c -lhidapi-libusb -o rifts-init

void printBuffer(char *buff, int length) {
  for (int i = 0; i < length; i++) {
    printf("%02x ", buff[i] & 0xFF);
  }

  printf("\n");
}

void clear_buff(char *buff, int length) {
  for (int i = 0; i < length; i++) {
    buff[i] = 0x00;
  }
}

int get_report(hid_device *hid, char id, char *buff, int length) {
  buff[0] = id;
  clear_buff(&buff[1], length-1);
  return hid_get_feature_report(hid, buff, length);
}

typedef struct DeviceInfo {
  char cmd;
  uint16_t v_resolution;
  uint16_t h_resolution;
  uint16_t unk0;
  char refreshRate;
  int32_t unk1;
  int32_t unk2;
  int32_t unk3;
  uint16_t unk4;
} __attribute__((aligned(1), packed));

int main() {
  struct hid_device_info* dev = hid_enumerate(0x2833, 0x0051);
  struct DeviceInfo devInfo;

  if (dev == NULL) {
    printf("Not found\n");
    return 1;
  }
  struct hid_device_info *d = dev;
  while (d != NULL) {
    //printf("%d\n", d->interface_number);
    if (d->interface_number == 0x07) {
      printf("FOUND\n");
      break;
    }
    d = d->next;
  }

  if (d == NULL) {
    printf("Not found\n");
    return 1;
  }

  hid_device *hid = hid_open_path(d->path);
  if (hid == NULL) {
    printf("FAIL %s\n", hid_error(hid));
    return 1;
  }

  char buff[65];

  int b = get_report(hid, 0x06, buff, 22);
  memcpy(&devInfo, buff, 22);
  printBuffer(buff, b);

  clear_buff(buff, 65);
  printf("%d\n", sizeof(devInfo));
  printf("Horiz: %u\nVert: %u\nHz: %u\n", devInfo.h_resolution, devInfo.v_resolution, devInfo.refreshRate);
  printf("Unk0: %u\nUnk1: %d\nUnk2: %d\nUnk3: %d\nUnk4: %u\n", devInfo.unk0, devInfo.unk1, devInfo.unk2, devInfo.unk3, devInfo.unk4);

  clear_buff(buff, 65);
  buff[0] = 0x14;
  buff[1] = 0x01;

  hid_send_feature_report(hid, buff, 2); // Enables Camera Device

  clear_buff(buff, 65);
  printf("Sending 0x0A 0x02\n");

  buff[0] = 0x0A;
  buff[1] = 0x02;

  hid_send_feature_report(hid, buff, 2); // Turn on Wireless

  clear_buff(buff, 65);

  buff[0] = 0x02;
  buff[1] = 0x01;

  hid_send_feature_report(hid, buff, 2); // Enables HMD

  hid_close(hid);
  hid_free_enumeration(dev);
}