#include <stdio.h>
#include <hidapi/hidapi.h>

void printBuffer(char *buff, int length) {
  for (int i = 0; i < length; i++) {
    printf("%02x ", buff[i] & 0xFF);
  }

  printf("\n");
}

void clear_buff(char *buff, int length) {
  for (int i = 0; i < length; i++) {
    buff[i] = 0x00;
  }
}

void get_report(hid_device *hid, char id, char *buff, int length) {
  buff[0] = id;
  clear_buff(&buff[1], length-1);
  hid_get_feature_report(hid, buff, length);
}

int main() {
  struct hid_device_info* dev = hid_enumerate(0x2833, 0x0051);
  if (dev == NULL) {
    printf("Not found\n");
    return 1;
  }
  struct hid_device_info *d = dev;
  while (d != NULL) {
    printf("%d\n", d->interface_number);
    if (d->interface_number == 0x07) {
      printf("FOUND\n");
      break;
    }
    d = d->next;
  }

  if (d == NULL) {
    printf("Not found\n");
    return 1;
  }

  hid_device *hid = hid_open_path(d->path);
  if (hid == NULL) {
    printf("FAIL %s\n", hid_error(hid));
    return 1;
  }

  char buff[65];

  get_report(hid, 0x4A, buff, 65);
  printBuffer(buff, 64);

  for (int i = 1; i < 65; i++) {
    buff[i] = 0x00;
  }

  buff[2] = 0x0D;
  buff[7] = 0x0C;

  printBuffer(buff, 64);

  hid_send_feature_report(hid, buff, 64);

  get_report(hid, 0x4A, buff, 64);
  printBuffer(buff, 64);

  clear_buff(buff, 65);
  buff[0] = 0x4A;

  buff[2] = 0x0D;
  buff[3] = 0x0C;
  buff[7] = 0x12;

  hid_send_feature_report(hid, buff, 64);

  get_report(hid, 0x4A, buff, 64);
  printBuffer(buff, 64);

  clear_buff(buff, 65);
  buff[0] = 0x07;
  buff[1] = 0x1B;
  buff[2] = 0x01;

  hid_send_feature_report(hid, buff, 3);
  clear_buff(buff, 65);

  // get_report(hid, 0x96, buff, 5);
  // printBuffer(buff, 5);

  // get_report(hid, 0x67, buff, 62);
  // printBuffer(buff, 62);

  clear_buff(buff, 65);
  buff[0] = 0x14;
  buff[1] = 0x01;

  hid_send_feature_report(hid, buff, 2); // Enables Camera Device

  // clear_buff(buff, 65);

  // buff[0] = 0x93;
  // buff[1] = 0x01;
  // buff[2] = 0xB8;
  // buff[3] = 0x0B;

  // hid_send_feature_report(hid, buff, 6);

  clear_buff(buff, 65);

  buff[0] = 0x0A;
  buff[1] = 0x02;

  hid_send_feature_report(hid, buff, 2);

  // clear_buff(buff, 65);

  // buff[0] = 0x4A;
  // buff[2] = 0x0F;
  // buff[7] = 0x0C;

  // hid_send_feature_report(hid, buff, 64);

  // get_report(hid, 0x4A, buff, 64);
  // printBuffer(buff, 64);

  // TODO Several 0x4A

  // clear_buff(buff, 65);
  // buff[0] = 0x12;
  // buff[1] = 0xE0;
  // buff[2] = 0xC7;
  // buff[3] = 0x10;
  // buff[4] = 0xC0;
  // buff[5] = 0xBD;
  // buff[6] = 0x25;
  // buff[7] = 0xED;
  // buff[8] = 0xE5;
  // buff[9] = 0x06;
  // buff[10] = 0x00;
  // buff[11] = 0xE8;
  // buff[12] = 0x03;

  // hid_send_feature_report(hid, buff, 61);

  // clear_buff(buff, 65);

  // buff[0] = 0x93;
  // buff[1] = 0x01;
  // buff[2] = 0xB8;
  // buff[3] = 0x0B;

  // hid_send_feature_report(hid, buff, 6);

  clear_buff(buff, 65);

  buff[0] = 0x02;
  buff[1] = 0x01;

  hid_send_feature_report(hid, buff, 2); // Enables HMD

  hid_close(hid);
  hid_free_enumeration(dev);
}