#!/usr/bin/env node

// npm install slackbots node-telegram-bot-api

var TelegramBot = require('node-telegram-bot-api');
var SlackBot = require('slackbots');

// create a bot
var sBot = new SlackBot({
    token: 'your-slack-bot-token', // Add a bot https://my.slack.com/services/new/bot and put the token
    name: 'Telegram Bot'
});

var slackChannelName = 'your_slack_channel';

var token = 'your-telegram-bot-token'; // Generate one with BotFather
// Setup polling way
var tBot = new TelegramBot(token, {polling: true});
var tChatId = -123456; // Your telegram group ID
var slackBotRunning = false;

// Any kind of message
tBot.on('message', function (msg) {
  var chatId = msg.chat.id;
  if (slackBotRunning && msg.chat.id === tChatId) {
    tBot.getUserProfilePhotos(msg.from.id).then(function(data) {
      if (data.total_count > 0) {
          var f = data.photos[0][0].file_id;
          tBot.getFileLink(f).then(function(fileURI) {
            sendSlackMessage(msg.from.first_name + " " + msg.from.last_name, msg.text, fileURI);
          });
      } else {
        sendSlackMessage(msg.from.first_name + " " + msg.from.last_name, msg.text);
      }
    });
  }
});

function sendSlackMessage(name, message, image) {
  console.log("(Slack) "+name+": "+message);
  var params = {};
  sBot.name = name + " (Telegram)";
  if (image !== undefined)
    params.icon_url = image;
  else
    params.icon_emoji = ':cat:';
  sBot.postMessageToGroup(slackChannelName, message, params);
}

sBot.on('start', function() {
    sBot.on('open', function() {
      console.log("SlackBot running");
      slackBotRunning = true;
      var params = {
          icon_emoji: ':cat:'
      };

      sendSlackMessage("Telegram Bot", "I'm online! YEY!");
      tBot.sendMessage(tChatId, "I'm online. YEY!");

      var users = {};

      sBot.getUsers().then(function(userlist) {
        console.log("Loaded "+userlist.members.length+" users.");
        for (var userC in userlist.members) {
          var user = userlist.members[userC];
          users[user.id] = user;
        }
      });

      sBot.on('message', function(data) {
        if (data.type === "message" && data.subtype !== 'bot_message') {
          var username = "Unknown";
          if (data.user in users)
            username = users[data.user].real_name + "[" + users[data.user].name + "]";
          console.log("(Telegram) "+username+": "+data.text);
          tBot.sendMessage(tChatId, username+": "+data.text);
        } else {
          console.log("Generic Message: ",data);
        }
      });
    });
});