#!/usr/bin/env python

import os, math
import collections

G1 = 0x79 # 171 octal
G2 = 0x5B # 131 octal

K = 7
UW = 0x1ACFFC1D

buff = collections.deque(maxlen=K)

def binary(num, length=8):
  return format(num, '#0{}b'.format(length + 2))

# Fill the buffer with initial values
for i in range(0, K):
  buff.append(0)


bitUW = []
binaryUW = binary(UW, 32)[2:]
for i in binaryUW:
  bitUW.append(int(i))

bitG1 = []
bitG2 = []
binaryG1 = binary(G1, K)[2:]
binaryG2 = binary(G2, K)[2:]
for i in range(0, K):
  bitG1.append(int(binaryG1[i]))
  bitG2.append(int(binaryG2[i]))

convolved = []

def buffIsZero():
  for i in range(0, K):
    if buff[i] == 1:
      return False
  return True

for i in bitUW:
  buff.appendleft(i)
  b0 = 0
  b1 = 0
  for t in range(0, K):
    b0 += bitG1[t] & buff[t]
    b1 += bitG2[t] & buff[t]
  b0 = b0 % 2
  b1 = b1 % 2
  b1 = 1 if b1 == 0 else 0
  convolved.append(b0)
  convolved.append(b1)

while True:
  buff.appendleft(0)
  if buffIsZero():
    break
  b0 = 0
  b1 = 0
  for t in range(0, K):
    b0 += bitG1[t] & buff[t]
    b1 += bitG2[t] & buff[t]
  b0 = b0 % 2
  b1 = b1 % 2
  b1 = 1 if b1 == 0 else 0
  convolved.append(b0)
  convolved.append(b1)

#convolved = convolved[:len(convolved)-2]

print convolved

f = open("UW.bit", "w")
t = open("UW_normal.bit", "w")
for s in range(0, 64):
  for i in bitUW:
    if i == 1:
      t.write(chr(0xFF))
      t.write(chr(0xFF))
      t.write(chr(0xFF))
    else:
      t.write(chr(0x00))
      t.write(chr(0x00))
      t.write(chr(0x00))
  for i in convolved:
    if i == 1:
      f.write(chr(0xFF))
      f.write(chr(0xFF))
      f.write(chr(0xFF))
    else:
      f.write(chr(0x00))
      f.write(chr(0x00))
      f.write(chr(0x00))

f.close()
t.close()