#!/usr/bin/env python
import os, struct

def manageFile(filename):
  f = open(filename, "r")

  try:
    type, filetypecode, headerlength, datalength = readHeader(f)
  except:
    print "   Header 0 is corrupted for file %s" %filename
    return

  newfilename = filename
  while f.tell() < headerlength:
    data = readHeader(f)
    if data[0] == 4:
      print "   Filename is %s" % data[1]
      newfilename = data[1]
      break
  f.close()
  if filename != newfilename:
    print "   Renaming %s to %s/%s" %(filename, os.path.dirname(filename), newfilename)
    os.rename(filename, "%s/%s" %(os.path.dirname(filename), newfilename))
  else:
    print "   Couldn't find name in %s" %filename

def readHeader(f):
  global t
  type = ord(f.read(1))
  size = f.read(2)
  size = struct.unpack(">H", size)[0]
  data = f.read(size-3)

  if type == 0:
    filetypecode, headerlength, datalength = struct.unpack(">BIQ", data)
    return type, filetypecode, headerlength, datalength
    #print "Header type: %s (%s) File Type Code: %s Header Length %s Data Field Length: %s" %(type,  HEADERTYPE_MAP[type], filetypecode, headerlength, datalength)
  elif type == 1:
    bitsperpixel, columns, lines, compression = struct.unpack(">BHHB", data)
    #print "Image Structure Header: "
    #print "   Bits Per Pixel: %s" %bitsperpixel
    #print "   Columns: %s" %columns
    #print "   Lines: %s" %lines
    #print "   Compression: %s" %compression
    return type, bitsperpixel, columns, lines, compression

  elif type == 2:
    projname, cfac, lfac, coff, loff = struct.unpack(">32sIIII", data)
    #print "Image Navigation Record"
    #print "   Projection Name: %s" %projname
    #print "   Column Scaling Factor: %s" %cfac
    #print "   Line Scaling Factor: %s" %lfac
    #print "   Column Offset: %s" %coff
    #print "   Line Offset: %s" %loff
    return type, projname, cfac, lfac, coff, loff

  elif type == 3:
    #print "Image Data Function Record"
    #print "   Data: {HIDDEN}"
    ##print "   Data: \n%s" %data
    return type, data

  elif type == 4:
    #print "Annotation Record"
    #print "   Data: %s" %data
    return type, data

  elif type == 5:
    #print "Timestamp Record"
    days, ms = struct.unpack(">HI", data[1:])
    #print "   Delta from 1 January 1958"
    #print "     Days: %s" %days
    #print "     Miliseconds: %s" %ms
    return type, days, ms

  elif type == 6:
    #print "Ancillary Text"
    #print "   Data: %s" %data
    return type, data

  elif type == 7:
    #print "Key Header"
    #print "   Data: %s" %data
    return type, data

  elif type == 128:
    imageid, sequence, startcol, startline, maxseg, maxcol, maxrow = struct.unpack(">7H", data)
    #print "Segment Identification Header"
    #print "   Image Id: %s" %imageid
    #print "   Sequence: %s" %sequence
    #print "   Start Column: %s" %startcol
    #print "   Start Line: %s" %startline
    #print "   Number of Segments: %s" %maxseg
    #print "   Width: %s" %maxcol
    #print "   Height: %s" %maxrow
    return type, imageid, sequence, startcol, startline, maxseg, maxcol, maxrow

  elif type == 129:
    #print "NOAA Specific Header"
    signature, productId, productSubId, parameter, compression = struct.unpack(">4sHHHB", data)
    #print "   Signature: %s" %signature
    #print "   Product ID: %s" %productId
    #print "   Product SubId: %s" %productSubId
    #print "   Parameter: %s" %parameter
    #print "   Compression: %s" %compression
    return type, signature, productId, productSubId, parameter, compression

  elif type == 130:
    #print "Header Structured Record"
    #print "   Data: %s" % data
    return type, data

  elif type == 131:
    #print "Rice Compression Record"
    flags, pixel, line = struct.unpack(">HBB", data)
    #print "   Flags: %s" %flags
    #print "   Pixel: %s" %pixel
    #print "   Line: %s" %line
    return type, flags, pixel, line

  else:
    #print "Type not mapped: %s" % type
    return type