#!/usr/bin/env python

import sys, struct, os

HEADERTYPE_MAP = {
  0: "Primary Header",
  1: "Image Structure",
  2: "Image Navigation",
  3: "Image Data Function",
  4: "Annotation",
  5: "Timestamp",
  6: "Acililary Text",
  7: "Key Header",
  128: "Segment Identification",
  129: "NOAA Specific",
  130: "Header Structured Record"
}

for i in range(8,128):
  HEADERTYPE_MAP[i] = "Reserved"

for i in range(131,256):
  HEADERTYPE_MAP[i] = "Reserved"

filename = "channels/53/1702_0_1311_1.lrit"

f = open(filename, "r")
fsize = os.path.getsize(filename)
readbytes = 0
t = 0

def readHeader(f):
  global t
  type = ord(f.read(1))
  size = f.read(2)
  size = struct.unpack(">H", size)[0]
  data = f.read(size-3)
  t += size
  if type == 0:
    filetypecode, headerlength, datalength = struct.unpack(">BIQ", data)
    print "Header type: %s (%s) File Type Code: %s Header Length %s Data Field Length: %s" %(type,  HEADERTYPE_MAP[type], filetypecode, headerlength, datalength)
  elif type == 1:
    bitsperpixel, columns, lines, compression = struct.unpack(">BHHB", data)
    print "Image Structure Header: "
    print "   Bits Per Pixel: %s" %bitsperpixel
    print "   Columns: %s" %columns
    print "   Lines: %s" %lines
    print "   Compression: %s" %compression

  elif type == 2:
    projname, cfac, lfac, coff, loff = struct.unpack(">32sIIII", data)
    print "Image Navigation Record"
    print "   Projection Name: %s" %projname
    print "   Column Scaling Factor: %s" %cfac
    print "   Line Scaling Factor: %s" %lfac
    print "   Column Offset: %s" %coff
    print "   Line Offset: %s" %loff

  elif type == 3:
    print "Image Data Function Record"
    print "   Data: {HIDDEN}"
    #print "   Data: \n%s" %data

  elif type == 4:
    print "Annotation Record"
    print "   Data: %s" %data

  elif type == 5:
    print "Timestamp Record"
    days, ms = struct.unpack(">HI", data[1:])
    print "   Delta from 1 January 1958"
    print "     Days: %s" %days
    print "     Miliseconds: %s" %ms

  elif type == 6:
    print "Ancillary Text"
    print "   Data: %s" %data

  elif type == 7:
    print "Key Header"
    print "   Data: %s" %data

  elif type == 128:
    print size
    imageid, sequence, startcol, startline, maxseg, maxcol, maxrow = struct.unpack(">7H", data)
    print "Segment Identification Header"
    print "   Image Id: %s" %imageid
    print "   Sequence: %s" %sequence
    print "   Start Column: %s" %startcol
    print "   Start Line: %s" %startline
    print "   Number of Segments: %s" %maxseg
    print "   Width: %s" %maxcol
    print "   Height: %s" %maxrow

  elif type == 129:
    print "NOAA Specific Header"
    signature, productId, productSubId, parameter, compression = struct.unpack(">4sHHHB", data)
    print "   Signature: %s" %signature
    print "   Product ID: %s" %productId
    print "   Product SubId: %s" %productSubId
    print "   Parameter: %s" %parameter
    print "   Compression: %s" %compression

  elif type == 130:
    print "Header Structured Record"
    print "   Data: %s" % data

  else:
    print "Type not mapped: %s" % type
  print ""

data = f.read(10)

filecounter, Transportlength = struct.unpack(">HQ", data)

print "File Counter: %s Transport Size: %s" %(filecounter, Transportlength)

readHeader(f)
readHeader(f)
readHeader(f)
readHeader(f)
readHeader(f)
readHeader(f)
readHeader(f)
readHeader(f)
readHeader(f)
readHeader(f)

print t

f.close()