#!/usr/bin/env python
import urllib
from urllib import urlencode
import urllib2
from time import sleep
import os
from subprocess import Popen, PIPE
import Image
from cStringIO import StringIO
import signal
import sys

framerate = 10
frame = 0
framecount = 60000
global password
global keep

keep = True

def signal_handler(signal, frame):
    global keep
    print('You pressed Ctrl+C!')
    keep = False
    sys.exit(0)

def GoProCMD(location, cmd, data):
    global password
    url = "http://10.5.5.9/%s/%s?t=%s&p=%s" %(location,cmd,password,data)
    ret = urllib2.urlopen(url).read()
    return ret
    
def GetImageName():
    data = urllib2.urlopen("http://10.5.5.9:8080/DCIM/").read()
    data = data.split("\"")
    folder = None
    for i in data:
        if "GOPRO" in i:
            folder = i.replace("/","")
            break
    if folder != None:
        #print "Found folder %s" %folder
        data = urllib2.urlopen("http://10.5.5.9:8080/DCIM/%s/" %folder).read()
        data = data.split("\"")
        image = None
        for i in data:
            if ".JPG" in i:
                image = i
                break
        if image != None:
            #print "Found Image %s"%image
            return "http://10.5.5.9:8080/DCIM/%s/%s" %(folder, image), image
        else:
            print "NOT FOUND"
            return None, None
    else:
        print "NOT FOUND"
        return None, None
            
def GetWifiPassword():
    return urllib2.urlopen("http://10.5.5.9/bacpac/sd").read().split("\n")[1]
    
def PhotoMode():
    return GoProCMD("camera","CM","%01")

def TakePicture():
    return GoProCMD("bacpac","SH","%01")
    
def DeleteLast():
    return GoProCMD("camera","DL","")
    
def DeleteAll():
    return GoProCMD("camera","DA","")

def WBAuto():
    return GoProCMD("camera","WB", "%00")
    
def WBRAW():
    return GoProCMD("camera","WB", "%04")

def Picture5MP():
    return GoProCMD("camera","PR","%03")
    
def Picture7MP():
    return GoProCMD("camera","PR","%04")
    
def Picture10MP():
    return GoProCMD("camera","PR","%08")

password = GetWifiPassword()
print "WiFi Password: %s" %password
print "Deleting all"
DeleteAll()
sleep(2)
ret = PhotoMode()
print "Photo Mode: %s" %ret
print "Setting to RAW"
WBRAW()

print "Setting to 7MP (Wide)"
Picture7MP()

print "Opening FFMPEG"
#p = Popen(['ffmpeg', '-y', '-f', 'image2pipe', '-vcodec', 'mjpeg', '-r', '%s'%framerate, '-i', '-', '-vcodec', 'libx264', '-pix_fmt', 'yuvj420p', '-r', '%s'%framerate, 'video.mp4'], stdin=PIPE)
p = Popen(['ffmpeg', '-y', '-f', 'image2pipe', '-vcodec', 'mjpeg', '-r', '%s'%framerate, '-i', '-', '-vcodec', 'libvpx', '-qmin' , '0' , '-qmax' , '5' , '-crf', '4', '-pix_fmt', 'yuv420p', '-r', '%s'%framerate, 'video.webm'], stdin=PIPE)

#p = Popen(['ffmpeg', '-y', '-f', 'image2pipe', '-vcodec', 'mjpeg', '-i', '-', '-vcodec', 'libx264', '-s', 'hd720', '-pix_fmt', 'yuv420p', '-f','flv', 'rtmp://localhost/live/gopro'], stdin=PIPE)

signal.signal(signal.SIGINT, signal_handler)
while frame != framecount:
    global keep
    print "Taking a picture %s" %frame
    try:
        ret = TakePicture()
        sleep(2)
        url, name = GetImageName()
    except:
        print "Connection Error"
        name = None
    if name == None:
        print "MISSING FRAME"
    else:
        print "Downloading Image: %s" %url
        try:
            data = urllib2.urlopen(url,timeout=3)
            size = int(data.headers["Content-Length"])
            data = data.read()
            if len(data) == size:
                p.stdin.write(data)
                f = open("pics/%s"%name,"w")
                f.write(data)
                f.close()
            else:
                print "Bad frame!"
        except:
            print "Error receiving frame"
    print "Deleting"
    try:
        DeleteLast()
        sleep(2)
    except:
        print "Connection Error"
    frame += 1
    if not keep:
        print "Got Signal to exit"
        break
        
os.killpg(p.pid, signal.SIGTERM) 