#include <Adafruit_NeoPixel.h>
#define PIN 6

Adafruit_NeoPixel strip = Adafruit_NeoPixel(40, PIN, NEO_GRB + NEO_KHZ800);

uint32_t matrix[5][8];
const float heartPeriod = 500;
const int rainbowPeriod = 10;
const float pattyLovePeriod = 200;

byte img[5][64] = {
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}
};

int stateMachine = 0;
int pattyLoveCycles = 0;
bool pattyLoveLock = true;
uint32_t lastTime = 0;

void setup() {
  // put your setup code here, to run once:

  strip.begin();
  strip.show(); // Initialize all pixels to 'off'
  for (int i=0; i<40; i++) {
    strip.setPixelColor(i, 0);
  }
  clearMatrix();
  Serial.begin(115200);
}

inline byte breath(float period) {
  return (byte) (127 * (sin(2 * PI * (1.0/period) * (millis()- lastTime) / PI) + 1));
}

inline void clearMatrix() {
  for (int x=0;x<8;x++) {
    for (int y=0;y<5;y++) {
      matrix[y][x] = 0;
    }
  }
}

inline void refreshMatrix() {
  // 5x8
  for (int x=0;x<8;x++) {
    for (int y=0;y<5;y++) {
      setColor(x, y, matrix[y][x]);
    }
  }
  strip.show();
}

inline void setColor(uint8_t x, uint8_t y, uint32_t color) {
  strip.setPixelColor(x + y * 8, color);
}

inline uint32_t proportional(uint32_t value, uint32_t intensity) {
  return (intensity * value / 255) & 0xFF;
}

void doPattyLove() {
  byte pos = ((int)((millis()- lastTime) / pattyLovePeriod)) % (64 - 8);
  if (pos == 0 && !pattyLoveLock) {
    pattyLoveCycles++;
    pattyLoveLock = true;
  } else if (pos != 0) {
    pattyLoveLock = false;
  }
  
  for (int x=0; x<8; x++) {
    for (int y=0; y<5; y++) {
      matrix[y][x] = img[y][x+pos] ? Wheel((x+pos)*8, 64)  : 0x000000;
    }
  }
}

void doHeart() {
  byte intensity = breath(heartPeriod);
  uint32_t pink = proportional(0xCC, intensity) << 16 | proportional(0x11, intensity);
  
  matrix[0][2] = pink;
  matrix[0][5] = pink;

  for (int i=1;i<7;i++) {
    matrix[1][i] = pink;
  }

  for (int i=1;i<7;i++) {
    matrix[2][i] = pink;
  }

  for (int i=1;i<6;i++) {
    matrix[2][i] = pink;
  }

  for (int i=2;i<6;i++) {
    matrix[3][i] = pink;
  }

  matrix[4][3] = pink;
  matrix[4][4] = pink;
}

void doRainbow() {
  byte pos = ((millis()- lastTime) / rainbowPeriod) & 255;
  for (int i=0; i< strip.numPixels(); i++) {
    matrix[i/8][i%8] = Wheel((i+pos) & 255, 32);
  }
}

uint32_t Wheel(byte WheelPos, byte intensity) {
  WheelPos = 255 - WheelPos;
  if(WheelPos < 85) {
    return strip.Color(proportional(255 - WheelPos * 3, intensity), 0, proportional(WheelPos * 3, intensity));
  }
  if(WheelPos < 170) {
    WheelPos -= 85;
    return strip.Color(0, proportional(WheelPos * 3, intensity), proportional(255 - WheelPos * 3, intensity));
  }
  WheelPos -= 170;
  return strip.Color(proportional(WheelPos * 3, intensity), proportional(255 - WheelPos * 3, intensity), 0);
}

void updateMachineState() {
  switch(stateMachine) {
    case 0:
      if (millis() - lastTime > 4600) {
        stateMachine = 1;
        lastTime = millis();
        pattyLoveCycles = 0;
        Serial.println("Patty Love!");
      }
      break;
    case 1:
      if (pattyLoveCycles == 1) {
        stateMachine = 2;
        lastTime = millis();
        Serial.println("Heart Only");
      }
      break;
    case 2:
      if (millis() - lastTime > 4000) {
        stateMachine = 3;
        lastTime = millis();
        Serial.println("Blank");
        clearMatrix();
      }
    case 3:
      if (millis() - lastTime > 5000) {
        stateMachine = 0;
        Serial.println("Heart BG");
        lastTime = millis();
      }
      break;
  }
}

void loop() {
  updateMachineState();
  switch (stateMachine) {
    case 0:
      doRainbow();
      doHeart();
      break;
    case 1:
      doPattyLove();
      break;
    case 2:
      doHeart();
      break;
  }
  
  refreshMatrix();
  delay(1);
}
