
package main
var constellationLut []map[byte]byte

var constellationLut []map[byte]byte

func rotateByte(v byte, n int, conj bool) byte {
    byteData := make([]int, 8)
    outByteData := make([]int, 8)

    // region convert to bits in bytes
    for i := 0; i < 8; i++ {
        byteData[i] = -127
        if v & (1 << uint(i)) > 0 {
            byteData[i] = 127
        }
    }
    // endregion
    // region Rotate
    for i := 0; i < 4; i++ {
        // Sync Word
        b0 := int(byteData[i*2])
        b1 := int(byteData[i*2+1])

        c := complex(float32(b0), float32(b1))
        for z := 0; z < n; z++ {
            c *= rotation90
        }

        outByteData[i*2] = int(f2bSoft(real(c)))
        if conj {
            outByteData[i*2+1] = int(f2bSoft(-imag(c)))
        } else {
            outByteData[i*2+1] = int(f2bSoft(imag(c)))
        }
    }
    // endregion
    // region Unmap to Byte
    v = 0
    for i := 0; i < 8; i++ {
        t := 0
        if outByteData[i] > 0 {
            t = 1
        }

        v |= byte(t << uint(i))
    }
    // endregion

    return v
}

func rotateSoftBuffer(buffer []byte, n int, conj bool) {
    for i := 0; i < len(buffer) / 2; i++ {
        // Sync Word
        b0 := int(buffer[i*2]) - 127
        b1 := int(buffer[i*2+1]) - 127

        c := complex(float32(b0), float32(b1))
        for z := 0; z < n % 4; z++ {
            c *= rotation90
        }

        buffer[i*2] = f2bSoft(real(c))
        if conj {
            buffer[i*2+1] = f2bSoft(-imag(c))
        } else {
            buffer[i*2+1] = f2bSoft(imag(c))
        }
    }
}

func init() {
    constellationLut = make([]map[byte]byte, 8) // 8 Ambiguities (4 for QPSK and 4 for conjugated QPSK (IQ inversion)

    for i := 0; i < 8; i++ {
        constellationLut[i] = map[byte]byte{}
    }

    for i := 0; i < 256; i++ {
        for n := 0; n < 4; n++ {
            constellationLut[n][byte(i)] = rotateByte(byte(i), n, false)
            constellationLut[n+4][byte(i)] = rotateByte(byte(i), n, true)
        }
    }
}