var rotation90 = complex(tools.Cos(float32(math.Pi/2)), tools.Sin(float32(math.Pi/2)))
func rotateByte(v byte, n int) byte {
    byteData := make([]byte, 8)
    outByteData := make([]byte, 8)

    // region convert to bits in bytes
    for i := 0; i < 8; i++ {
        byteData[i] = -127
        if v & (1 << uint(i)) > 0 {
            byteData[i] = 127
        }
    }
    // endregion
    // region Rotate
    for i := 0; i < 4; i++ {
        // Sync Word
        b0 := int(byteData[i*2])
        b1 := int(byteData[i*2+1])

        // 0 degrees
        c := complex(float32(b0), float32(b1))
        for z := 0; z < n; z++ {
            c *= rotation90
        }
        outByteData[i*2] = f2b(real(c))
        outByteData[i*2+1] = f2b(imag(c))
    }
    // endregion
    // region Unmap to Byte
    v = 0
    for i := 0; i < 8; i++ {
        t := 0
        if outByteData[i] > 0 {
            t = 1
        }

        v |= byte(t << uint(i))
    }
    // endregion

    return v
}