#include <Adafruit_NeoPixel.h>
#define PIN 6

Adafruit_NeoPixel strip = Adafruit_NeoPixel(40, PIN, NEO_GRB + NEO_KHZ800);

#define LARGURA 8

uint32_t matrix[5][LARGURA];
const float heartPeriod = 500;
const int rainbowPeriod = 10;
const float textCyclePeriod = 200;

byte img[5][64] = {
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0},
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
   {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}
};

int stateMachine = 0;
int textCycleCycles = 0;
bool textCycleLock = true;
uint32_t lastTime = 0;

void setup() {
  // put your setup code here, to run once:

  strip.begin();
  strip.show(); // Initialize all pixels to 'off'
  for (int i=0; i<40; i++) {
    strip.setPixelColor(i, 0);
  }
  clearMatrix();
  Serial.begin(115200);
}

inline byte breath(float period) {
  return (byte) (127 * (sin(2 * PI * (1.0/period) * (millis()- lastTime) / PI) + 1));
}

inline void clearMatrix() {
  for (int x=0;x<LARGURA;x++) {
    for (int y=0;y<5;y++) {
      matrix[y][x] = 0;
    }
  }
}

inline void refreshMatrix() {
  // 5x8
  for (int x=0;x<LARGURA;x++) {
    for (int y=0;y<5;y++) {
      setColor(x, y, matrix[y][x]);
    }
  }
  strip.show();
}

inline void setColor(uint8_t x, uint8_t y, uint32_t color) {
  strip.setPixelColor(x + y * LARGURA, color);
}

inline uint32_t proportional(uint32_t value, uint32_t intensity) {
  return (intensity * value / 255) & 0xFF;
}

void dotextCycle() {
  byte pos = ((int)((millis()- lastTime) / textCyclePeriod)) % (64 - LARGURA);
  if (pos == 0 && !textCycleLock) {
    textCycleCycles++;
    textCycleLock = true;
  } else if (pos != 0) {
    textCycleLock = false;
  }
  
  for (int x=0; x<LARGURA; x++) {
    for (int y=0; y<5; y++) {
      matrix[y][x] = img[y][x+pos] ? Wheel((x+pos)*LARGURA, 64)  : 0x000000;
    }
  }
}


uint32_t Wheel(byte WheelPos, byte intensity) {
  WheelPos = 255 - WheelPos;
  if(WheelPos < 85) {
    return strip.Color(proportional(255 - WheelPos * 3, intensity), 0, proportional(WheelPos * 3, intensity));
  }
  if(WheelPos < 170) {
    WheelPos -= 85;
    return strip.Color(0, proportional(WheelPos * 3, intensity), proportional(255 - WheelPos * 3, intensity));
  }
  WheelPos -= 170;
  return strip.Color(proportional(WheelPos * 3, intensity), proportional(255 - WheelPos * 3, intensity), 0);
}

void loop() {
  dotextCycle();
  refreshMatrix();
  delay(1);
}