; A B C D                  = 8 bits
; IP = Instruction Pointer = 16 bits = 65535
; SP = Stack Pointer       = 16 bits = 65535
;      |       AX        |
;                |   A   |
; AX = 0000 0000 0000 0000
; AX, BX, CX, DX           = 16 bits
;       |                 EAX                 |
;                           |        AX       |
;                           |   Ah   |    Al  |
;                                    |     A  |
; EAX = 0000 0000 0000 0000 0000 0000 0000 0000
; EAX, EBX, ECX, EDX       = 32 bits
; EIP = Enhanced IP        = 32 bits
; ESP = Enhanced SP        = 32 bits
;
; ----- PAE - Physical Address Extension ------
;
;
; RAX, RBX, RCX, RDX       = 64 bits
; RIP = Register IP        = 64 bits
; RSP = Register SP        = 64 bits


mov EAX, EBX ; A = B
mov EBX, EAX ; B = A
add EAX, EBX ; A = A + B
sub EAX, EBX ; A = A - B
inc EAX    ; A = A + 1
inc AX
inc A
dec EBX    ; B = B - 1

; RAX = int64 = 64 bits = 1844674407370955161
; 88         × 10   ^   27  m
; 5          × 10   ^   -5  m
;  /\          /\       /\
; Mantissa    Base   Expoente
; 1 sinal 57 bits mantissa - 1 sinal 5 bits de expoente
;  88  25                    ( -31 a 31 )
; ponto flutuante decimal => a * 10 ^ b
;
;
; 5 * 2   = 10   ;  0101 * 0000 0010 = 0000 1010
; 5 * 4   = 20   ;  0101 * 0000 0100 = 0001 0100
; 5 * 8   = 40   ;  0101 * 0000 1000 = 0010 1000
; 5 * 16  = 80   ;  0101 * 0001 0000 = 0101 0000
; 5 / 2   =  2   ;  0101 / 0000 0010 = 0000 0010

; float = 32 bit
; Base 2
; ponto flutuante binario => a * 2 ^ b
;
;
; Mantissa 8 bits = 1 bit sinal, 7 bits numero
; -128 a 127
; Expoente 4 bits = 1 bit sinal, 3 bits numero
; -8 a 7
; |  Matissa  |  Expoente  |     Valor
; |S| Numero  |S|
;  0  0000001  0     000   |  1  * 10 ^  0  = 1
;  0                       | 12  * 10 ^ -2  = 0.12
;  0           1     011   |128  * 10 ^ -3  = 0.128
;                          | 13  * 10 ^ -2  = 0.13
;  0  0101001  1     010   | 25  * 10 ^ -2  = 0.25
;  0  1001011  1     010   | 75  * 10 ^ -2  = 0.75
;  0  0000101  1     001   |  5  * 10 ^ -1  = 0.5
;  0  0000010  0     000   |  2  * 10 ^  0  = 2
; a * 0.5 == a / 2
; multiplicacoes em FLOAT = ~3
; divisoes em FLOAT       = ~7
; ´

; MMX, SSE, AVX, 3DNOW, NEON
; XMM0 = 4 x 64  bits = 4 double
; XMM0 = 8 x 32  bits = 8 float
; XMM0 - XMM15 = 16 FUCKING REGISTRADORES DE 256 BITS
;
; XMM0 + XMM1 == 1 instrução
;
;    XMM0[0], XMM0[1], XMM0[2], XMM0[3]
; *  XMM1[0], XMM1[1], XMM1[2], XMM1[3]
; =
; FMA = Fused-multiply-add
; XMM0 * XMM1 + XMM2  =>> ONE FUCKING INSTRUCTION!!!
; SIMD = Single Instruction Multiple Data