#!/bin/bash

echo "Setting up Wireless network"
/sbin/iwconfig wlan0 mode ad-hoc channel 11 essid "papo-de-sysadmin"
/sbin/ip link set up dev wlan0
/sbin/ifconfig wlan0 192.168.10.8 netmask 255.255.255.0

echo "Killing any previous running babeld"
kill -9 `cat /var/run/babeld.pid 2>>/dev/null` 2>>/dev/null 
rm /var/run/babeld.pid 2>>/dev/null
rm /var/log/babeld.log 2>>/dev/null

echo "Waiting"
sleep 2
iwconfig |grep papo

if [ $? -eq 1 ]
then
	echo "Wrong Network"
	exit 1
else
	echo "Network OK!"
	iwconfig wlan0
fi

sleep 1

echo "Starting babeld"

/usr/local/bin/babeld
sleep 4

ps |grep babel |grep -v grep |grep -v startbabel
exit $?

echo "Finished!"

