#!/bin/bash
LOCKFILE=/tmp/bkpvmail
if [ -e ${LOCKFILE} ] && kill -0 `cat ${LOCKFILE}`
then
        echo "Já rodando!"
        exit
fi

trap "rm -f ${LOCKFILE}; exit" INT TERM EXIT
echo $$ > ${LOCKFILE}
ORIGEM=/home/vmail
SPLITSIZE="100M"
DESTINO=/dados/backup/vmail/
NOME=auto
QTDE=7
CONTADOR=0
PLATFORM=$(uname)
ID=`date +%Y-%m-%d-%H-%M-%S`
LOG=/dados/backup/logs/vmail-$ID.log


echo "Iniciando Backup $0 - `date`" > $LOG

if [ ! -d $DESTINO ]; then
        mkdir $DESTINO
fi
ULTIMO_BACKUP=`find $DESTINO -maxdepth 1 -name "$NOME.*" | sort -nr | head -n 1`
find $DESTINO -maxdepth 1 -name "$NOME.*" | sort -nr | tail -n +`expr $QTDE + 1` | while read antigo; do
rm -rf "$antigo"        2>>$LOG 1>>$LOG
done
BACKUP_ATUAL="$DESTINO/$NOME.$ID"         2>>$LOG 1>>$LOG
echo "- Criando pasta $BACKUP_ATUAL" >> $LOG
mkdir $BACKUP_ATUAL        2>>$LOG 1>>$LOG
echo "- Efetuando backup dos emails para $BACKUP_ATUAL" >> $LOG
cp -Rp $ORIGEM/* $BACKUP_ATUAL/        2>>$LOG 1>>$LOG
echo "- Compactando o backup dos emails" >> $LOG
tar -pczf - $BACKUP_ATUAL/* | split -d -b $SPLITSIZE - $DESTINO/vmail.tar.gz 2>>$LOG 1>>$LOG
echo "- Apagando arquivos não compactados" >> $LOG
rm  -fr $BACKUP_ATUAL/*         2>>$LOG 1>>$LOG
echo "- Movendo arquivo compactado $DESTINO/vmail.tar.gz para $BACKUP_ATUAL" >> $LOG
mv $DESTINO/vmail.tar.gz* $BACKUP_ATUAL        2>>$LOG 1>>$LOG
rm -f ${LOCKFILE}
