#include <SPI.h>

#define SCK  D5
#define MISO D6
#define CS   D8
#define MOSI D7


void setup() {
  Serial.begin(115200);
  Serial.println("OK");

  pinMode(SCK, OUTPUT);
  pinMode(CS, OUTPUT);
  pinMode(MOSI, OUTPUT);
  pinMode(MISO, INPUT);

  digitalWrite(CS, HIGH);

  SPI.pins(SCK, MISO, MOSI, CS);
  SPI.begin();
}

void loop() {
  digitalWrite(CS, LOW);
  uint8_t data = SPI.transfer(0xFF); // Always transfer full 1 bits
  digitalWrite(CS, HIGH);

  Serial.println(data, BIN);
  delay(100);
}