#include <SPI.h>

#define SCK  D5
#define MISO D6
#define CS   D8
#define MOSI D7


void setup() {
  Serial.begin(115200);
  Serial.println("OK");

  pinMode(SCK, OUTPUT);
  pinMode(CS, OUTPUT);
  pinMode(MOSI, OUTPUT);
  pinMode(MISO, INPUT);

  digitalWrite(CS, HIGH);

  SPI.pins(SCK, MISO, MOSI, CS);
  SPI.begin();
}

void loop() {
  digitalWrite(CS, LOW);
  uint8_t data = SPI.transfer(0xFF); // Always transfer full 1 bits
  digitalWrite(CS, HIGH);

  uint8_t flag = data & 0x80; // Get the 7th bit
  data &= 0x7F; // Reset it, so we have only the pure value in data

  if (data != 0x7F) {
    // We have some data, not all 1's
    if (flag) { // Buttons
      Serial.print("BUTTONS: ");
      switch (data) {
        case 0:
          Serial.println("RIGHT");
          break
        case 1:
          Serial.println("POWER");
          break
        case 2:
          Serial.println("LEFT");
          break
      }
    } else {    // Slider
      Serial.print("SLIDER: ");
      // MAX is 54 and MIN is 1 so:
      uint16_t v = (uint16_t)data;
      v -= 1;   // MIN
      v *= 100; // Percent
      v /= (54 - 1);  // MAX - MIN
      Serial.print(v);
      Serial.println("%");
    }
  }
  delay(100);
}