#!/usr/bin/env python

import time
from zipfile import ZipFile

numfiles = 20
c = 0

def parseEMWINHeader(data):

  if not data[0] == '/':
    print "Invalid Header: %s" % data[:80]
    return False

  head = data[:80]
  filename = head[1:15]
  partNumber = head[18:24]
  partTotal = head[27:33]
  cs = head[36:43]
  dateTime = head[46:]

  return {
    "filename": filename,
    "partNumber": int(partNumber),
    "partTotal": int(partTotal),
    "cs": int(cs),
    "dateTime": dateTime
  }

def findSyncMarker(data):
  found = False
  pos = -1
  for i in range(len(data)-13):
    t = True
    for z in range(13):
      if z == 12:
        if not data[i+z] == '/':
          t = False
          break
      else:
        if not ord(data[i+z]) == 0x00:
          t = False
          break
    if t:
      pos = i
      break
  return pos

buff = ""

files = {}

while True:
  if c == numfiles:
    break
  f = open("%s_0.emwin" % c, "rb")
  data = f.read()
  f.close()
  c += 1
  buff += data
  pos = findSyncMarker(buff)
  if pos == -1:
    print "Marker not found"
    continue

  buff = buff[pos:]

  if len(buff) < 1116:
    #print "Not yet enough data"
    continue

  data = buff[pos:pos+1116]
  buff = buff[pos+1116:]
  data = data[12:]
  if len(data) > 0:
    header = parseEMWINHeader(data)
    if header != False:
      data = data[80:]
      filename = header["filename"]
      partNumber = header["partNumber"]
      partTotal = header["partTotal"]
      print "Received %s/%s of %s" %(header["partNumber"], header["partTotal"], header["filename"])
      if partNumber == 1:
        tstamp = int(round(time.time()))
        outFile = "%s-%s" %(tstamp, filename)
        files[filename] = { "parts": partTotal, "received": 0, "output": outFile }

      if not filename in files:
        print "Received incomplete file %s" %filename
      elif files[filename]["received"] + 1 != partNumber:
        print "Missed %s frames for file %s" %(partNumber + 1 - partNumber, filename)
      else:
        f = open("%s" %files[filename]["output"], "wb" if partNumber == 1 else "ab")
        f.write(data)
        f.close()
        files[filename]["received"] += 1
      if partNumber == partTotal and filename in files:
        print "Finished file %s" %filename
        if ".ZIS" in filename:
          f = ZipFile(files[filename]["output"], "r")
          f.extractall()
        files.pop(filename, None)
