/*
 * VPXEncoder.h
 *
 *  Created on: 28/12/2013
 *      Author: lucas
 *      Based on: http://www.webmproject.org/docs/vp8-sdk/example__simple__encoder.html
 *      An part of StepFever project.
 */

#include "../game.h"

#ifndef VPXENCODER_H_
#define VPXENCODER_H_

//#define VPX_CODEC_DISABLE_COMPAT 1

#include "vpx/vpx_encoder.h"
#include "vpx/vp8cx.h"

#define interface (vpx_codec_vp8_cx())
#define fourcc    0x30385056

#define IVF_FILE_HDR_SZ  (32)
#define IVF_FRAME_HDR_SZ (12)

extern "C" {
	#include <x264.h>
	#include <libswscale/swscale.h>
	#include <libavcodec/avcodec.h>
}


class VPXEncoder {
private:
	static inline void mem_put_le16(char *mem, unsigned int val) {	    mem[0] = val;	    mem[1] = val>>8;	}
	static inline void mem_put_le32(char *mem, unsigned int val) {	    mem[0] = val;	    mem[1] = val>>8;	    mem[2] = val>>16;	    mem[3] = val>>24;	}
	static void write_ivf_file_header(FILE *outfile, const vpx_codec_enc_cfg_t *cfg, int frame_cnt);
	static void write_ivf_frame_header(FILE *outfile, const vpx_codec_cx_pkt_t *pkt);
	static void die_codec(vpx_codec_ctx_t *ctx, const char *s);

public:
	VPXEncoder();
	virtual ~VPXEncoder();
	bool open(std::string filename); 								/* open for encoding */
	bool encode(char* pixels, bool ReflectY); 						/* encode the given data */
	bool encode(char* pixels) { return encode(pixels, false); };	/* encode the given data */
	bool close(); 													/* close the encoder and file, frees all memory */

	// Params

    FILE                *outfile;
    vpx_codec_ctx_t      codec;
    vpx_codec_enc_cfg_t  cfg;
    int                  frame_cnt = 0;
    vpx_image_t          raw;
    vpx_codec_err_t      res;
    int                  frame_avail;
    int                  got_data;
    int                  flags = 0;

	int in_width;
	int in_height;
	int out_width;
	int out_height;
	AVPixelFormat in_pixel_format;
	AVPixelFormat out_pixel_format;
	AVPicture pic_raw;

    struct SwsContext* sws;
};

#endif /* VPXENCODER_H_ */
