#!/bin/bash
LOCKFILE=/tmp/bkpmysql
if [ -e ${LOCKFILE} ] && kill -0 `cat ${LOCKFILE}`
then
        echo "Já rodando!"
        exit
fi

trap "rm -f ${LOCKFILE}; exit" INT TERM EXIT
echo $$ > ${LOCKFILE}

DB_USER='usuario'
DB_PASS='senha'
DB_PARAM='--all-databases --add-drop-table --add-locks --extended-insert --single-transaction -quick'

DESTINO=/dados/backup/data/mysql/
TMPDESTINO=/dados/backup/tmp/mysql/
NOME=auto
QTDE=5
CONTADOR=0
PLATFORM=$(uname)
PARSIZE=100m

if [ ! -d $DESTINO ]; then
        mkdir $DESTINO
fi
ULTIMO_BACKUP=`find $DESTINO -maxdepth 1 -name "$NOME.*" | sort -nr | head -n 1`
find $DESTINO -maxdepth 1 -name "$NOME.*" | sort -nr | tail -n +`expr $QTDE + 1` | while read antigo; do
rm -rf "$antigo"
done
ID=`date +%Y-%m-%d-%H-%M-%S`
BACKUP_ATUAL="$DESTINO/$NOME.$ID"
echo "- Criando pasta $BACKUP_ATUAL"
mkdir $BACKUP_ATUAL
if [ "$ULTIMO_BACKUP" != "" ]; then
        echo "- Copiando pasta $ULTIMO_BACKUP para $BACKUP_ATUAL"
        if [ "$PLATFORM" == "FreeBSD" ]; then
                pasta=$(pwd)
                cd $ULTIMO_BACKUP
                pax -rwl -pe . $BACKUP_ATUAL
                cd $pasta
        fi
fi

echo "- Efetuando Backup do MySQL para $TMPDESTINO"
mysqldump $DB_PARAM -u $DB_USER -p$DB_PASS > $TMPDESTINO/mysql.sql
echo "- Compactando $TMPDESTINO para $BACKUP_ATUAL com partes de tamanho $PARSIZE"
tar cz $TMPDESTINO/* | split -b $PARSIZE - $BACKUP_ATUAL/mysql.tar.gz
echo "- Limpando $TMPDESTINO"
rm -fr $TMPDESTINO/*
rm -f ${LOCKFILE}