#!/usr/bin/env python
#
# jnlp_crawler.py - Download all the jar files in a jnlp file for offline examination
# Sheran Gunasekera
#

from xml.dom.minidom import parse
from xml.parsers.expat import ExpatError
import urllib
import sys

to_download = []
try:
	dom = parse(sys.argv[1])
except ExpatError as (strerror):
	print "!! JNLP File Parsing error -- "+str(strerror)
	sys.exit(1)
jnlp = dom.getElementsByTagName("jnlp")
codebase = jnlp[0].getAttribute("codebase")
resources = dom.getElementsByTagName("resources")
for resource in resources:
	jar = resource.getElementsByTagName("jar")
	for attributes in jar:
		to_download.append(attributes.getAttribute("href"))
for url in to_download:
	try:
		print "+ Attempt to fetch "+codebase+url
		urllib.urlretrieve(codebase+url,url.split('/')[-1])
		print "+ Done"
	except IOError as (errno, strerror):
		print "!! Failed -- "+strerror
	except KeyboardInterrupt:
		sys.exit(0)