import struct
import zlib

def decryptprofile(savedata,rankdata):
    
    seed = 0xEBADA1
    for i in range(0,len(savedata)):
        smbuff = savedata[i]
        savedata[i] ^= (seed >> 8) & 0xFF
        seed = (0x68993 * (smbuff + seed) + 0x4FDCF) & 0xFFFFFFFF
    
    seed = 0xEBADA1        
    for i in range(0,len(rankdata)):
        smbuff = rankdata[i]
        rankdata[i] ^= (seed >> 8) & 0xFF
        seed = (0x68993 * (smbuff + seed) + 0x4FDCF) & 0xFFFFFFFF
    
    return savedata,rankdata

def encryptprofile(savedata,rankdata):
    adlerseed = struct.unpack("<I",savedata[4:8])
    newsaveadler = zlib.adler32(savedata[4:],adlerseed[0]) & 0xFFFFFFFF
    newrankadler = zlib.adler32(rankdata[4:],adlerseed[0]) & 0xFFFFFFFF
    
    #savedata[0:4] = struct.pack("<I",newsaveadler)
    #rankdata[0:4] =  struct.pack("<I",newrankadler)
    savedata = struct.pack("<I",newsaveadler) + savedata[4:]
    rankdata = struct.pack("<I",newrankadler) + rankdata[4:]
    
    savedata = bytearray(savedata)
    rankdata = bytearray(rankdata)
    
    seed = 0xEBADA1
    for i in range(0,len(savedata)):
        smbuff = savedata[i] ^ (seed >> 8) & 0xFF
        savedata[i] = smbuff
        seed = (0x68993 * (smbuff + seed) + 0x4FDCF) & 0xFFFFFFFF
    
    seed = 0xEBADA1        
    
    for i in range(0,len(rankdata)):
        smbuff = rankdata[i] ^ (seed >> 8) & 0xFF
        rankdata[i] = smbuff
        seed = (0x68993 * (smbuff + seed) + 0x4FDCF) & 0xFFFFFFFF    
    
    return savedata,rankdata