# High Quality Spectrum Painting

A quick tutorial on how to get high quality images from gr-paint and Gqrx.

![Spectrum Example](http://www.w6rz.net/paintpalvin.png)

## Setup

 * Use a newer version of Gqrx with Ref. level and dB range sliders.
 * Set the FFT size in Gqrx to 32768
 * Set the waterfall rate to 50 or 60 fps


## Calibration

* Transmit the supplied ramp.bin file.
* Adjust the Ref. level and dB range sliders so that the test pattern lowest level bar is at black or near black and the highest level bar is at bright yellow.

![Calibration Example](http://www.w6rz.net/paintcal.png)

![Calibration Example](http://www.w6rz.net/paintpanda.png)

## Black and white waterfall hack

 * In the file gqrx/src/qtgui/plotter.cpp, make the following change.

```
    // default waterfall color scheme
#if 0
    for (int i = 0; i < 256; i++)
    {
        // level 0: black background
        if (i < 20)
            m_ColorTbl[i].setRgb(0, 0, 0);
        // level 1: black -> blue
        else if ((i >= 20) && (i < 70))
            m_ColorTbl[i].setRgb(0, 0, 140*(i-20)/50);
        // level 2: blue -> light-blue / greenish
        else if ((i >= 70) && (i < 100))
            m_ColorTbl[i].setRgb(60*(i-70)/30, 125*(i-70)/30, 115*(i-70)/30 + 140);
        // level 3: light blue -> yellow
        else if ((i >= 100) && (i < 150))
            m_ColorTbl[i].setRgb(195*(i-100)/50 + 60, 130*(i-100)/50 + 125, 255-(255*(i-100)/50));
        // level 4: yellow -> red
        else if ((i >= 150) && (i < 250))
            m_ColorTbl[i].setRgb(255, 255-255*(i-150)/100, 0);
        // level 5: red -> white
        else if (i >= 250)
            m_ColorTbl[i].setRgb(255, 255*(i-250)/5, 255*(i-250)/5);
    }
#else
    for (int i = 0; i < 256; i++)
    {
        if (i < 64)
        {
            m_ColorTbl[i].setRgb(i*4, i*4, i*4);
        }
        else
        {
            m_ColorTbl[i].setRgb(255, 255, 255);
        }
    }
#endif
```

 * Note that the levels will be compressed, so the waterfall will need to be re-calibrated.

![Calibration Example Black and white](http://www.w6rz.net/paintcalbw.png)

 * High contrast images work best, especially drawings.

![High Contrast Example](http://www.w6rz.net/paintliz11.png)

![High Contrast Example](http://www.w6rz.net/paintbowie.png)

![High Contrast Example](http://www.w6rz.net/paintqpsk.png)