#include <stdio.h>
#include <SatHelper/sathelper.h>

#define FRAMEBYTES 8192
#define FRAMEBITS (FRAMEBYTES * 8)

using namespace SatHelper;
using namespace std;


unsigned char symbols[8 * 2 * (FRAMEBYTES + 6)];
unsigned char bits[FRAMEBYTES];
unsigned char output[FRAMEBYTES];

int main(int argc, char **argv) {

  FILE *f = fopen("jpss.dec", "rb");
  FILE *z = fopen("jpss.vit.dec", "wb");
  Viterbi27 viterbi(FRAMEBITS+6);

  fseek(f, 0, 2);

  int size = ftell(f);

  fseek(f, 0, 0);

  int bytesRead = 0;

  while (bytesRead < size) {
    fread(symbols, FRAMEBITS, 1, f);
    viterbi.decode(symbols, output);
    fwrite(output, FRAMEBYTES, 1, z);
    bytesRead += FRAMEBITS;
  }

  cout << "File Size: " << size << endl;

  //viterbi.decode(symbols, output);

  fclose(f);
  fclose(z);
  return 0;
}