package main

import (
	asm "github.com/twitchyliquid64/golang-asm"
	"github.com/twitchyliquid64/golang-asm/obj"
	"github.com/twitchyliquid64/golang-asm/obj/x86"
	"os"
)

func clearReg(builder *asm.Builder, reg int16) *obj.Prog {
	prog := builder.NewProg()
	prog.As = x86.AXORQ
	prog.From.Type = obj.TYPE_REG
	prog.From.Reg = reg
	prog.To.Type = obj.TYPE_REG
	prog.To.Reg = reg
	return prog
}

func movRegToReg(builder *asm.Builder, src, dst int16) *obj.Prog {
	prog := builder.NewProg()

	prog.As = x86.AMOVQ
	prog.From.Type = obj.TYPE_REG
	prog.From.Reg = src
	prog.To.Type = obj.TYPE_REG
	prog.To.Reg = dst
	return prog
}

func noop(builder *asm.Builder) *obj.Prog {
	prog := builder.NewProg()
	prog.As = x86.ANOPL
	prog.From.Type = obj.TYPE_REG
	prog.From.Reg = x86.REG_AX
	return prog
}

func addImmediateByte(builder *asm.Builder, in int32) *obj.Prog {
	prog := builder.NewProg()
	prog.As = x86.AADDB
	prog.To.Type = obj.TYPE_REG
	prog.To.Reg = x86.REG_AL
	prog.From.Type = obj.TYPE_CONST
	prog.From.Offset = int64(in)
	return prog
}

func movImmediateByte(builder *asm.Builder, reg int16, in int32) *obj.Prog {
	prog := builder.NewProg()
	prog.As = x86.AMOVQ
	prog.To.Type = obj.TYPE_REG
	prog.To.Reg = reg
	prog.From.Type = obj.TYPE_CONST
	prog.From.Offset = int64(in)
	return prog
}

func movMemoryByReg(builder *asm.Builder, reg, memoryReg int16, offset int64) *obj.Prog {
	prog := builder.NewProg()
	prog.As = x86.AMOVQ
	prog.To.Type = obj.TYPE_REG
	prog.To.Reg = reg
	prog.From.Type = obj.TYPE_MEM
	prog.From.Reg = memoryReg
	prog.From.Offset = offset
	return prog
}

func lea(builder *asm.Builder, reg int16, addr int32) *obj.Prog {
	prog := builder.NewProg()
	prog.As = x86.ALEAQ
	prog.To.Type = obj.TYPE_REG
	prog.To.Reg = reg
	prog.From.Type = obj.TYPE_MEM
	prog.From.Offset = int64(addr)

	return prog
}

func syscall(builder *asm.Builder) *obj.Prog {
	prog := builder.NewProg()

	prog.As = x86.ASYSCALL
	prog.To.Type = obj.TYPE_NONE
	prog.From.Type = obj.TYPE_NONE

	return prog
}

func addRet(builder *asm.Builder) *obj.Prog {
	prog := builder.NewProg()

	prog.As = obj.ARET

	return prog
}
func main() {
	huebr := "huebr\n"
	b, _ := asm.NewBuilder("amd64", 64)

	b.AddInstruction(movRegToReg(b, x86.REG_DI, x86.REG_CX))
	b.AddInstruction(movImmediateByte(b, x86.REG_AX, 1))
	b.AddInstruction(movImmediateByte(b, x86.REG_DI, int32(os.Stdout.Fd())))
	b.AddInstruction(movMemoryByReg(b, x86.REG_SI, x86.REG_CX, 0))
	b.AddInstruction(movMemoryByReg(b, x86.REG_DX, x86.REG_CX, 8))
	b.AddInstruction(syscall(b))
	b.AddInstruction(addRet(b))

	insts := ToExecutableMemory(b.Assemble())

	var myCall func(data string)

	BuildTo(insts, &myCall)

	myCall(huebr)

	//fmt.Printf("Bin: %x\n", b.Assemble())
}
