import serial
import time

PORT = "/dev/ttyUSB0"       #   If windows, change it to COMX
PINCODE = "1234"            #   Change it to your PIN
DEVNAME = "Gimbal"          #   Change it to your device name
BAUDRATE= 115200            #   Change it to your target baudrate
CBAUDRATE= 9600             #   Change it to your current baudrate. Factory Default 9600



baudlist = {
    1200    :   "AT+BAUD1",
    2400    :   "AT+BAUD2",
    4800    :   "AT+BAUD3",
    9600    :   "AT+BAUD4",
    19200   :   "AT+BAUD5",
    38400   :   "AT+BAUD6",
    57600   :   "AT+BAUD7",
    115200  :   "AT+BAUD8"
}

print "Opening Serial Port"
ser = serial.Serial(PORT, CBAUDRATE, timeout=1)

print "Opened. Sending AT"
ser.write("AT")
data = ser.read(20)
print "Received: %s" %data
time.sleep(1)

print "Sending PINCODE Change: %s" %("AT+PIN%s"%PINCODE)
ser.write("AT+PIN%s"%PINCODE)
data = ser.read(20)
print "Received: %s" %data
time.sleep(1)

print "Sending DEVNAME Change: %s" %("AT+NAME%s"%DEVNAME)
ser.write("AT+NAME%s"%DEVNAME)
data = ser.read(20)
print "Received: %s" %data
time.sleep(1)

if baudlist.has_key(BAUDRATE):
    print "Sending BAUDRATE Change: %s" %(baudlist[BAUDRATE])
    ser.write(baudlist[BAUDRATE])
    data = ser.read(20)
    print "Received: %s" %data
    time.sleep(1)
else:
    print "Invalid baudrate %s. Skipping." %BAUDRATE

print "Finished!"
