#pragma once

#include <algorithm>
#include <map>
#include <stdexcept>

#include "common/common.h"

// Based on Golang Implementation
// MIT

namespace ProtoRock {
namespace Http {
struct UserInfo {
    std::string Username;
    std::string Password;

    UserInfo() {}
    UserInfo(const std::string &u) : Username(u){};
};

struct URL {
   private:
    void setFragment(const std::string &);
    void setPath(const std::string &);

   public:
    std::string Scheme;
    // encoded opaque data
    std::string Opaque;
    // username and password information
    UserInfo User;
    // host or host:port
    std::string Host;
    // path (relative paths may omit leading slash)
    std::string Path;
    // encoded path hint (see EscapedPath method)
    std::string RawPath;
    // append a query ('?') even if RawQuery is empty
    bool ForceQuery = false;
    // encoded query values, without '?'
    std::string RawQuery;
    // fragment for references, without '#'
    std::string Fragment;
    // encoded fragment hint (see EscapedFragment method)
    std::string RawFragment;

    static URL Parse(std::string url);
    static std::string PathEscape(const std::string &path);
    static std::string PathUnescape(const std::string &path);
    static std::string QueryEscape(const std::string &query);
    static std::string QueryUnescape(const std::string &query);
};

}  // namespace Http
}  // namespace ProtoRock