#include <SPI.h>

#define SCK  D5
#define MISO D6
#define CS   D8
#define MOSI D7


void setup() {
  Serial.begin(115200);
  Serial.println("OK");

  pinMode(SCK, OUTPUT);
  pinMode(CS, OUTPUT);
  pinMode(MOSI, OUTPUT);
  pinMode(MISO, INPUT);

  digitalWrite(CS, HIGH);

  SPI.pins(SCK, MISO, MOSI, CS);
  SPI.begin();
}

void loop() {
  digitalWrite(CS, LOW);
  uint8_t data = SPI.transfer(0xFF); // Always transfer full 1 bits
  digitalWrite(CS, HIGH);

  uint8_t flag = data & 0x80; // Get the 7th bit
  data &= 0x7F; // Reset it, so we have only the pure value in data

  if (flag) { // Buttons
    Serial.print("BUTTONS: ");
    Serial.println(data, BIN);
  } else {    // Slider
    Serial.print("SLIDER: ");
    Serial.println(data, DEC);
  }
  delay(100);
}