using NHibernate;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Reflection.Emit;
using System.Text;
using System.Threading.Tasks;

namespace DatabaseSample {
  public static class ServiceProducer<T> {

    public static T ProduceService() {
      var myType = CompileResultType<T>();
      return (T)Activator.CreateInstance(myType);
    }

    public static Type CompileResultType<T>() {
      TypeBuilder tb = GetTypeBuilder<T>();
      ConstructorBuilder constructor = tb.DefineDefaultConstructor(MethodAttributes.Public | MethodAttributes.SpecialName | MethodAttributes.RTSpecialName);

      return tb.CreateType();
    }
    private static TypeBuilder GetTypeBuilder<T>() {
      var typeSignature = "customType_" + typeof(T).Name;
      var an = new AssemblyName(typeSignature);
      AssemblyBuilder assemblyBuilder = AppDomain.CurrentDomain.DefineDynamicAssembly(an, AssemblyBuilderAccess.Run);
      ModuleBuilder moduleBuilder = assemblyBuilder.DefineDynamicModule("MainModule");
      TypeBuilder tb = moduleBuilder.DefineType(typeSignature
                          , TypeAttributes.Public |
                          TypeAttributes.Class |
                          TypeAttributes.AutoClass |
                          TypeAttributes.AnsiClass |
                          TypeAttributes.BeforeFieldInit |
                          TypeAttributes.AutoLayout
                          , typeof(T));

      typeof(T).GetMethods().ToList().ForEach(m => {
        MethodBuilder mbM = tb.DefineMethod(m.Name, MethodAttributes.Public | MethodAttributes.ReuseSlot | MethodAttributes.Virtual | MethodAttributes.HideBySig,
            m.ReturnType,
            m.GetParameters().ToList().Select(a => a.ParameterType).ToArray());

        var il = mbM.GetILGenerator();

        il.DeclareLocal(typeof(ISessionFactory));
        il.DeclareLocal(typeof(ISession));
        il.DeclareLocal(typeof(ITransaction));
        il.DeclareLocal(typeof(Exception));
        if (!typeof(void).IsAssignableFrom(m.ReturnType)) {
          il.DeclareLocal(m.ReturnType);
        }

        Label transactionNull = il.DefineLabel();
        Label exit = il.DefineLabel();

        // try {
        il.BeginExceptionBlock();

        // BaseService._session = BaseService._sessionFactory.OpenSession();
        writeLine(il, "GettingSession");
        il.Emit(OpCodes.Nop);
        il.Emit(OpCodes.Ldsfld, typeof(BaseService).GetField("_sessionFactory"));
        il.Emit(OpCodes.Stloc_0);

        writeLine(il, "Session got!");
        il.Emit(OpCodes.Ldloc_0);
        il.Emit(OpCodes.Call, typeof(ISessionFactory).GetMethod("OpenSession", new Type[0]));
        il.Emit(OpCodes.Stloc_1);

        writeLine(il, "Saving session");
        il.Emit(OpCodes.Ldloc_1);
        il.Emit(OpCodes.Stsfld, typeof(BaseService).GetField("_session", BindingFlags.NonPublic | BindingFlags.Static));
        il.Emit(OpCodes.Nop);

        // transaction = BaseService._session.BeginTransaction()
        writeLine(il, "Creating Transaction");
        il.Emit(OpCodes.Ldsfld, typeof(BaseService).GetField("_session", BindingFlags.NonPublic | BindingFlags.Static));
        il.Emit(OpCodes.Call, typeof(ISession).GetMethod("BeginTransaction", new Type[0]));
        il.Emit(OpCodes.Stloc_2);


        // base.{thismethod}({parameters})
        writeLine(il, "Calling parent");
        il.Emit(OpCodes.Ldarg_0);
        UInt16 i = 1;
        m.GetParameters().ToList().ForEach(a => {
          il.Emit(OpCodes.Ldarg, i);
          i++;
        });

        il.EmitCall(OpCodes.Call, m, new Type[0]);
        if (!typeof(void).IsAssignableFrom(m.ReturnType)) {
          il.Emit(OpCodes.Stloc, 4);
        }

        // transaction.Commit();
        writeLine(il, "Commiting Transaction");
        il.Emit(OpCodes.Ldloc_2);
        il.Emit(OpCodes.Call, typeof(ITransaction).GetMethod("Commit"));

        // } catch (Exception) {
        il.BeginCatchBlock(typeof(Exception));
        il.Emit(OpCodes.Pop);

        // transaction.Commit();
        writeLine(il, "Rolling back Transaction");
        il.Emit(OpCodes.Ldloc_2);
        il.Emit(OpCodes.Brfalse_S, transactionNull);
        il.Emit(OpCodes.Ldloc_2);
        il.Emit(OpCodes.Call, typeof(ITransaction).GetMethod("Rollback"));
        writeLine(il, "Exception got!");
        il.MarkLabel(transactionNull);
        il.Emit(OpCodes.Rethrow);


        // } finally {
        il.BeginFinallyBlock();
        // BaseService._session.Close();
        writeLine(il, "Closing session");
        il.Emit(OpCodes.Ldsfld, typeof(BaseService).GetField("_session", BindingFlags.NonPublic | BindingFlags.Static));
        il.Emit(OpCodes.Brfalse_S, exit);
        il.Emit(OpCodes.Ldsfld, typeof(BaseService).GetField("_session", BindingFlags.NonPublic | BindingFlags.Static));
        il.Emit(OpCodes.Call, typeof(ISession).GetMethod("Close"));
        il.Emit(OpCodes.Pop);
        //}
        il.EndExceptionBlock();

        // return {returndata}
        if (!typeof(void).IsAssignableFrom(m.ReturnType)) {
          il.Emit(OpCodes.Ldloc, 4);
        }

        il.MarkLabel(exit);
        il.Emit(OpCodes.Ret);
      });

      return tb;
    }

    private static void writeLine(ILGenerator il, string line) {
      il.Emit(OpCodes.Ldstr, line);
      il.Emit(OpCodes.Call, typeof(Console).GetMethod("WriteLine", new Type[] { typeof(string) }));
    }
  }
}
