import serial
import struct
import os
import sys
import time

class AxisPipe:
    def __init__(self, port):
        self.port   =   port
        self.serial =   serial.Serial(port, 115200, timeout=0.01)
        self.axis   =   [ 0,0,0,0 ]
        self.aux    =   [ 0,0 ]
        
    def UpdateAxis(self, axis, value):
        if self.axis[axis] != value & 0xFFFF:
            print "Updating Axis %s with %s" %(axis,value)
            print "HUE(%s,%s)" % (value&0xFF,(value/256) & 0xFF)
            self.axis[axis] = value & 0xFFFF
            self.serial.write(struct.pack("BBB",axis,value&0xFF,(value/256)&0xFF))
            
    def UpdateAux(self, aux, value):
        if self.aux[aux] != value & 0xFFFF:
            print "Updating Aux %s with %s" %(aux,value)
            self.aux[aux] = value & 0xFFFF
            self.serial.write(struct.pack("BBB",aux+7,value&0xFF,value/256))
            
    def SetLed(self, val):
        self.serial.write(struct.pack("BBB",4,val&0xFF,0))
        
    def ReadData(self):
        data = self.serial.readline()
        if len(data) > 1:
            print "Response: %s" %data.replace("\n","")
            
    def TurnOn(self):
        self.serial.write("\x05\x00\x00")
        self.UpdateAxis(0,1500);
        self.UpdateAxis(1,1500);
        self.UpdateAxis(2,1500);
        self.UpdateAxis(3,1500);

        self.UpdateAux(0,1500);
        self.UpdateAux(1,1500);

    def TurnOff(self):
        self.serial.write("\x06\x00\x00")
        
    def KeepAlive(self):
        self.serial.write("\x09\x00\x00")

    def Close(self):
        self.TurnOff()
        self.serial.close()   